function checkCode() {
  const code = document.getElementById("access-code").value.trim();
  const content = contentMap[code];
  const contentArea = document.getElementById("content-area");
  const errorMessage = document.getElementById("error-message");

  if (content) {
    const image = document.getElementById("content-image");
    const video = document.getElementById("content-video");

    image.src = content.image;
    video.querySelector("source").src = content.video;
    video.load();

    contentArea.classList.remove("scv-hidden");
    errorMessage.classList.add("scv-hidden");
  } else {
    contentArea.classList.add("scv-hidden");
    errorMessage.classList.remove("scv-hidden");
  }
}

// Disable right-click on image and video
document.addEventListener("DOMContentLoaded", () => {
  const img = document.getElementById("content-image");
  const vid = document.getElementById("content-video");

  if (img) {
    img.addEventListener("contextmenu", e => e.preventDefault());
    img.setAttribute("draggable", "false");
  }
  if (vid) {
    vid.addEventListener("contextmenu", e => e.preventDefault());
  }
});
