<?php

/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * ACF Field Display
 * Displays Advanced Custom Field values.
 */

if ( !class_exists( 'ss_app_store_button' ) )
{
	class ss_app_store_button extends aviaShortcodeTemplate
	{
		/**
		 * Create the config array for the shortcode button
		 */
		function shortcode_insert_button()
		{
			$template_url = get_stylesheet_directory_uri();
			$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
			$this->config['name']		= __('App Store Badge', 'avia_framework' );
			$this->config['tab']		= __('Spiderfly Elements', 'avia_framework' );
			$this->config['icon']		= $child_sc_imgs."app-button.png";
			$this->config['order']		= 20;
			$this->config['target']		= 'avia-target-insert';
			$this->config['modal_data'] = array('modal_class' => 'ssmed');
			$this->config['shortcode'] 	= 'app_store_button';
			$this->config['tooltip'] 	= __('Displays various app store buttons.', 'avia_framework' );
			$this->config['drag-level'] = 3;
			$this->config['tinyMCE'] 	= array('disable' => "true");
		}

		
		/**
			 * Popup Elements
			 *
			 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
			 * opens a modal window that allows to edit the element properties
			 *
			 * @return void
			 */
			function popup_elements()
			{
				if(is_rtl()): wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css',false,'1.1','all'); else: wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css',false,'1.1','all'); endif;
				$this->elements = array(
					
					array(
							"type" 	=> "tab_container", 'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Content" , 'avia_framework'),
							'nodescription' => true
						),
					
					array(	
							"name" 	=> __("App Store", 'avia_framework' ),
							"desc" 	=> __("Select an app store.", 'avia_framework' ),
							"id" 	=> "app_store",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array("Apple"=>'apple',"Google Play"=>'google',"Amazon"=>'amazon',"Windows"=>'windows')
							),

					array(	
						"name" 	=> __("App Store Link", 'avia_framework' ),
						"desc" 	=> __("Enter the URL to the app store.", 'avia_framework' ),
						"id" 	=> "store_link",
						"std" 	=> "",
						"type" 	=> "input"),
					
					array(	
						"name" 	=> __("Badge Width", 'avia_framework' ),
						"desc" 	=> __("Enter a value of pixels or percentage. Eg. 250px or 50%.", 'avia_framework' ),
						"id" 	=> "badge_width",
						"std" 	=> "",
						"type" 	=> "input"),
					
					array(	
							"name" 	=> __("Badge Mobile Width", 'avia_framework' ),
							"desc" 	=> __("Select a width for mobile display.", 'avia_framework' ),
							"id" 	=> "badge_mobile",
							"type" 	=> "select",
							"std" 	=> "100",
							"subtype" => array("100%"=>'full',"50%"=>'half')
							),
					
					array(	
							"name" 	=> __("Badge Float", 'avia_framework' ),
							"desc" 	=> __("Set the CSS float of the badge.", 'avia_framework' ),
							"id" 	=> "badge_float",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array("None"=>'none',"Float Left"=>'left',"Float Right"=>'right')
							),
					
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
					array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
	
								
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
								
					array(
						"type" 	=> "close_div",
						'nodescription' => true
					),	
				
				);
		}


		/**
		 * Editor Element - this function defines the visual appearance of an element on the AviaBuilder Canvas
		 * Most common usage is to define some markup in the $params['innerHtml'] which is then inserted into the drag and drop container
		 * Less often used: $params['data'] to add data attributes, $params['class'] to modify the className
		 *
		 *
		 * @param array $params this array holds the default values for $content and $args.
		 * @return $params the return array usually holds an innerHtml key that holds item specific markup.
		 */
		function editor_element($params)
		{
			$params['innerHtml'] = "<img src='".$this->config['icon']."' title='".$this->config['name']."' />";
			$params['innerHtml'].= "<div class='avia-element-label'>".$this->config['name']."</div>";
			$params['content'] 	 = NULL; //remove to allow content elements
			return $params;
		}



		/**
		 * Frontend Shortcode Handler
		 *
		 * @param array $atts array of attributes
		 * @param string $content text within enclosing form of shortcode element
		 * @param string $shortcodename the shortcode found, when == callback name
		 * @return string $output returns the modified html string
		 */
		function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
		{
			extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes
			extract(shortcode_atts(array('app_store'=>'', 'store_link'=>'', 'badge_width'=>'', 'badge_mobile'=>'', 'badge_float'=>''), $atts, $this->config['shortcode']));
			
			$template_url = get_stylesheet_directory_uri();
			$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
			
			if($badge_width) {$badgewidth = "width:".$badge_width.";";}
			if($badge_float) {$badgefloat = "float:".$badge_float.";";}
			
			if($app_store == 'apple') {$applink = '<a itemprop="downloadUrl" class="'.$badge_mobile.'" style="'.$badgewidth.$badgefloat.'" href="'.$store_link.'" target="_blank"><img class="applelink" src="'.$child_sc_imgs.'apple-badge.png" /></a>';}
			if($app_store == 'google') {$applink = '<a itemprop="downloadUrl" class="'.$badge_mobile.'" style="'.$badgewidth.$badgefloat.'" href="'.$store_link.'" target="_blank"><img class="googlelink" src="'.$child_sc_imgs.'google-play-badge.png" /></a>';}
			if($app_store == 'amazon') {$applink = '<a itemprop="downloadUrl" class="'.$badge_mobile.'" style="'.$badgewidth.$badgefloat.'" href="'.$store_link.'" target="_blank"><img class="amazonlink" src="'.$child_sc_imgs.'amazon-badge.png" /></a>';}
			if($app_store == 'windows') {$applink = '<a itemprop="downloadUrl" class="'.$badge_mobile.'" style="'.$badgewidth.$badgefloat.'" href="'.$store_link.'" target="_blank"><img class="windowslink" src="'.$child_sc_imgs.'windows-badge.png" /></a>';}
			
			$output  = "";
			$output .= "<div class='applink {$extraClass} {$av_display_classes}'>".$applink."</div>";
						
			return $start_wrap.$output.$end_wrap;
		}
	}
}
