<?php
/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * Modern Featured Image
 * Displays a product image with a modern style
 */


if ( !class_exists( 'avia_featured_img_modern' ) ) 
{
	class avia_featured_img_modern extends aviaShortcodeTemplate
	{
			/**
			 * Create the config array for the shortcode button
			 */
			function shortcode_insert_button()
			{
				$template_url = get_stylesheet_directory_uri();
				$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
				$this->config['name']		= __('Modern Featured Image', 'avia_framework' );
				$this->config['tab']		= __('Spiderfly Elements', 'avia_framework' );
				$this->config['icon']		= $child_sc_imgs."product-img.png";
				$this->config['order']		= 97;
				$this->config['target']		= 'avia-target-insert';
				$this->config['shortcode'] 	= 'featured_img_modern';
				$this->config['tooltip'] 	= __('Displays the featured image with a modern style.', 'avia_framework' );
				$this->config['tinyMCE']    = array('disable'=>true);
				$this->config['modal_data'] = array('modal_class' => 'mediumscreen');
				$this->config['preview'] 	= false;
			}
		
		public function __construct( $builder ) 
		{
			add_filter( 'avf_preview_window_css_files', array( $this, 'handler_avf_preview_window_css_files'), 10, 1 );
				
			parent::__construct( $builder );
		}

		public function handler_avf_preview_window_css_files( $css = array() )
		{
			
			if(is_rtl()): $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css'; else: $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css'; endif;
			
			$css[ $css_url ] = 1;
			return $css;
		}
		
		function extra_assets()
			{
				if(is_rtl()): wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css',false,'1.1','all'); else: wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css',false,'1.1','all'); endif;
			}

		
			/**
			 * Popup Elements
			 *
			 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
			 * opens a modal window that allows to edit the element properties
			 *
			 * @return void
			 */
			function popup_elements()
			{

				$this->elements = array(
					
					array(
							"type" 	=> "tab_container", 'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Content" , 'avia_framework'),
							'nodescription' => true
						),
											
				    array(	
						"name" 	=> __("Link Settings", 'avia_framework' ),
						"desc" 	=> __("Select whether or not you would like the image linked to a larger image via lightbox.", 'avia_framework' ),
						"id" 	=> "link_img",
						"type" 	=> "select",
						"std" 	=> "lightbox-img",
						"subtype" => array("No Link"=>'no-link',"Lightbox"=>'lightbox-img')
						), 
						
					array(	
						"name" 	=> __("Tagline", 'avia_framework' ),
						"desc" 	=> __("Enter what you would like displayed when the product is on sale.<br /><strong>Example:</strong> SALE - 10% OFF<br />To disable the sale badge completely, simply leave the field blank.", 'avia_framework' ),
						"id" 	=> "tagline",
						"std" 	=> "",
						"type" 	=> "input"),
							
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Style Options" , 'avia_framework'),
							'nodescription' => true
						),
							
					array(	
							"name" 	=> __("Sale Text Style", 'avia_framework' ),
							"desc" 	=> __("Select the text style for the sale tagline.", 'avia_framework' ),
							"id" 	=> "sale",
							"type" 	=> "select",
							"container_class" => 'av_half',
							"std" 	=> "light",
							"subtype" => array("Light"=>'light',"Dark"=>'dark')
							),
							
					array(	
							"name" 	=> __("Sale Badge Background Color", 'avia_framework' ),
							"desc" 	=> __("Select any color to use for the badge background.", 'avia_framework' ),
							"id" 	=> "sale_bg",
							"type" 	=> "colorpicker",
							"container_class" => 'av_half',
							"std" 	=> "#d54e21",
						),  
						
					array(	
							"name" 	=> __("Image Hover Effect",'avia_framework' ),
							"desc" 	=> __("Check to disable the image hover effect.", 'avia_framework'),
							"id" 	=> "img_effect",
							"std" 	=> "",
							"type" 	=> "checkbox"),
						
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
					array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
						
								
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
						
						
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
				);

			}
			
			
			/**
			 * Frontend Shortcode Handler
			 *
			 * @param array $atts array of attributes
			 * @param string $content text within enclosing form of shortcode element 
			 * @param string $shortcodename the shortcode found, when == callback name
			 * @return string $output returns the modified html string 
			 */
			function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
			{

			    extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes 
				extract(shortcode_atts(array('tagline' => 'SALE', 'sale' => '', 'sale_bg' => '', 'link_img' => '', 'img_effect' => '' ), $atts, $this->config['shortcode']));
			   
			    $meta['el_class'];
			
					
				$featured_image = get_the_post_thumbnail( $post_id, 'gallery' );
				$featured_image_large = get_the_post_thumbnail_url( $post_id, 'large' );
							
				$sale  = $atts['sale'];
				$sale_bg  = $atts['sale_bg'];
				if($sale == 'light') $sale = 'style="color:#f5f5f5; background-color:'.$sale_bg.' !important;"';
				if($sale == 'dark') $sale = 'style="color:#151515; text-shadow:none !important; background-color:'.$sale_bg.' !important;"';
				
				$tagline  = $atts['tagline'];
				if ( $tagline ) {
					$saletag = '<h3 '.$sale.' class="sale">'.$tagline.'</h3>';
				}
				
				$link_img  = $atts['link_img'];
				if ($link_img == 'lightbox-img'){
				$featimglink = '<a href="'.$featured_image_large.'"></a>';
				}
				if ($link_img == 'nolink'){
				$featimglink = '';
				}
				
				if ($link_img == 'lightbox-img'){
				$clicktext = '<div class="avia_textblock text-center itemprop="text"><p style="margin-top:0px !important; margin-bottom:25px !important;"><small>CLICK TO PREVIEW</small></p></div>';
				}
				if ($link_img == 'nolink'){
				$clicktext = '';
				}
				
				$img_effect = $atts['img_effect'];
				if ($img_effect) {$featured_image = "<img src=".get_the_post_thumbnail_url( $post_id, 'shop_catalog' )." style='-webkit-transform: none !important; transform: none !important;' />";}
			    
			    $output = "";
			    $output .= '<figure class="modprod {$av_display_classes}">'. $featured_image;
				$output .= '<figcaption style="background-image:none !important;">';
				$output .= $saletag;
				$output .= '</figcaption>'.$featimglink;
				$output .= '</figure>'.$clicktext;
				
				return $output;
			}
	}
}
